//=============================================================================
// Wafobar7.
//=============================================================================
class WafoBulkPack7 extends MSBulkPacks;

#exec TEXTURE IMPORT FILE="C:\DeusEx\MSBulk\Textures\WafoBulkBox7.pcx"		NAME="WafoBulkPack7"				GROUP="Skins" MIPS=Off
#exec TEXTURE IMPORT FILE="C:\DeusEx\MSBulk\Textures\IconWafoBulkPack7.pcx"	NAME="IconWafoBulkPack7"			GROUP="Icons" MIPS=Off FLAGS=2

var travel int NumBars;
var travel int SavedNumBars;

replication
{
	// Things the server should send to the client.
	reliable if( Role==ROLE_Authority && bNetOwner )
		NumBars;
}

function TravelPostAccept()
{
 Super.TravelPostAccept();
 
 NumBars = SavedNumBars;
 UpdateBulkDescription();
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot >= 0);
}

function string ByteToHex(Color MamaBytes) // lol
{
 local string Red1, Red2, Green1, Green2, Blue1, Blue2;
 local float RedDummy, GreenDummy, BlueDummy;
 local int BigRed, RedAdd, BigGreen, GreenAdd, BigBlue, BlueAdd; 
 local string RedFinal, GreenFinal, BlueFinal;
 local string FinalHex;

//----------------------------
//RED
//----------------------------

 BigRed = -1;
 RedDummy = MamaBytes.R; // get the red byte
 RedDummy = RedDummy / 15;

 //SUPER MASSIVE IF SCENARIO FUN TIME!
 if (RedDummy == 17) { Red1 = "F"; Red2 = "F"; BigRed = -2; } //h4x
 if ((RedDummy >= 16) && (RedDummy < 17) && (BigRed == -1)) { RedDummy -= 16; BigRed = 16; }
 if ((RedDummy >= 15) && (RedDummy < 16) && (BigRed == -1)) { RedDummy -= 15; BigRed = 15; } 
 if ((RedDummy >= 14) && (RedDummy < 15) && (BigRed == -1)) { RedDummy -= 14; BigRed = 14; } 
 if ((RedDummy >= 13) && (RedDummy < 14) && (BigRed == -1)) { RedDummy -= 13; BigRed = 13; } 
 if ((RedDummy >= 12) && (RedDummy < 13) && (BigRed == -1)) { RedDummy -= 12; BigRed = 12; } 
 if ((RedDummy >= 11) && (RedDummy < 12) && (BigRed == -1)) { RedDummy -= 11; BigRed = 11; } 
 if ((RedDummy >= 10) && (RedDummy < 11) && (BigRed == -1)) { RedDummy -= 10; BigRed = 10; } 
 if ((RedDummy >= 9) && (RedDummy < 10) && (BigRed == -1)) { RedDummy -= 9; BigRed = 9; } 
 if ((RedDummy >= 8) && (RedDummy < 9) && (BigRed == -1)) { RedDummy -= 8; BigRed = 8; } 
 if ((RedDummy >= 7) && (RedDummy < 8) && (BigRed == -1)) { RedDummy -= 7; BigRed = 7; } 
 if ((RedDummy >= 6) && (RedDummy < 7) && (BigRed == -1)) { RedDummy -= 6; BigRed = 6; } 
 if ((RedDummy >= 5) && (RedDummy < 6) && (BigRed == -1)) { RedDummy -= 5; BigRed = 5; } 
 if ((RedDummy >= 4) && (RedDummy < 5) && (BigRed == -1)) { RedDummy -= 4; BigRed = 4; } 
 if ((RedDummy >= 3) && (RedDummy < 4) && (BigRed == -1)) { RedDummy -= 3; BigRed = 3; } 
 if ((RedDummy >= 2) && (RedDummy < 3) && (BigRed == -1)) { RedDummy -= 2; BigRed = 2; }  
 if ((RedDummy >= 1) && (RedDummy < 2) && (BigRed == -1)) { RedDummy -= 1; BigRed = 1; } 
 if ((RedDummy >= 0) && (RedDummy < 1) && (BigRed == -1)) { BigRed = 0; Red1 = "0"; }
 RedDummy = RedDummy * 15; //find out how many we have in the ones space

if ((BigRed <= 16) && (BigRed > 0)) //if we're not over 16
{
 BigRed -= 1; //adjust the biggy for recording
 Red1 = ""$BigRed$""; //record the biggy
 RedAdd = 15 - BigRed; //find the difference between the biggy and 15
 RedDummy += RedAdd; //then add the difference to the ones space
if (RedDummy > 15) //if we've broken the normal limit
{
 RedDummy -= 15; //settle the difference
 BigRed += 1; //and fix the biggy
 Red1 = ""$BigRed$""; //then RE-record the biggy because of FUBAR-ness
}
}
if (Red2 == "")
 Red2 = ""$int(RedDummy)$""; //record the final result
//------------------------------
//convert results to hexadecimal
//------------------------------
//part 1
if (Red1 == "10") Red1 = "A";
if (Red1 == "11") Red1 = "B";
if (Red1 == "12") Red1 = "C";
if (Red1 == "13") Red1 = "D";
if (Red1 == "14") Red1 = "E";
if (Red1 == "15") Red1 = "F";
//part 2
if (Red2 == "10") Red2 = "A";
if (Red2 == "11") Red2 = "B";
if (Red2 == "12") Red2 = "C";
if (Red2 == "13") Red2 = "D";
if (Red2 == "14") Red2 = "E";
if (Red2 == "15") Red2 = "F";
//combine results...
RedFinal = ""$Red1$""$Red2$"";

//----------------------------
//GREEN
//----------------------------
 BigGreen = -1;
 GreenDummy = MamaBytes.G; // get the Green byte
 GreenDummy = GreenDummy / 15;

 //SUPER MASSIVE IF SCENARIO FUN TIME!
 if (GreenDummy == 17) { Green1 = "F"; Green2 = "F"; BigGreen = -2; } //h4x
 if ((GreenDummy >= 16) && (GreenDummy < 17) && (BigGreen == -1)) { GreenDummy -= 16; BigGreen = 16; }
 if ((GreenDummy >= 15) && (GreenDummy < 16) && (BigGreen == -1)) { GreenDummy -= 15; BigGreen = 15; } 
 if ((GreenDummy >= 14) && (GreenDummy < 15) && (BigGreen == -1)) { GreenDummy -= 14; BigGreen = 14; } 
 if ((GreenDummy >= 13) && (GreenDummy < 14) && (BigGreen == -1)) { GreenDummy -= 13; BigGreen = 13; } 
 if ((GreenDummy >= 12) && (GreenDummy < 13) && (BigGreen == -1)) { GreenDummy -= 12; BigGreen = 12; } 
 if ((GreenDummy >= 11) && (GreenDummy < 12) && (BigGreen == -1)) { GreenDummy -= 11; BigGreen = 11; } 
 if ((GreenDummy >= 10) && (GreenDummy < 11) && (BigGreen == -1)) { GreenDummy -= 10; BigGreen = 10; } 
 if ((GreenDummy >= 9) && (GreenDummy < 10) && (BigGreen == -1)) { GreenDummy -= 9; BigGreen = 9; } 
 if ((GreenDummy >= 8) && (GreenDummy < 9) && (BigGreen == -1)) { GreenDummy -= 8; BigGreen = 8; } 
 if ((GreenDummy >= 7) && (GreenDummy < 8) && (BigGreen == -1)) { GreenDummy -= 7; BigGreen = 7; } 
 if ((GreenDummy >= 6) && (GreenDummy < 7) && (BigGreen == -1)) { GreenDummy -= 6; BigGreen = 6; } 
 if ((GreenDummy >= 5) && (GreenDummy < 6) && (BigGreen == -1)) { GreenDummy -= 5; BigGreen = 5; } 
 if ((GreenDummy >= 4) && (GreenDummy < 5) && (BigGreen == -1)) { GreenDummy -= 4; BigGreen = 4; } 
 if ((GreenDummy >= 3) && (GreenDummy < 4) && (BigGreen == -1)) { GreenDummy -= 3; BigGreen = 3; } 
 if ((GreenDummy >= 2) && (GreenDummy < 3) && (BigGreen == -1)) { GreenDummy -= 2; BigGreen = 2; }  
 if ((GreenDummy >= 1) && (GreenDummy < 2) && (BigGreen == -1)) { GreenDummy -= 1; BigGreen = 1; } 
 if ((GreenDummy >= 0) && (GreenDummy < 1) && (BigGreen == -1)) { BigGreen = 0; Green1 = "0"; }
 GreenDummy = GreenDummy * 15; //find out how many we have in the ones space

if ((BigGreen <= 16) && (BigGreen > 0)) //if we're not over 16
{
 BigGreen -= 1; //adjust the biggy for recording
 Green1 = ""$BigGreen$""; //record the biggy
 GreenAdd = 15 - BigGreen; //find the difference between the biggy and 15
 GreenDummy += GreenAdd; //then add the difference to the ones space
if (GreenDummy > 15) //if we've broken the normal limit
{
 GreenDummy -= 15; //settle the difference
 BigGreen += 1; //and fix the biggy
 Green1 = ""$BigGreen$""; //then RE-record the biggy because of FUBAR-ness
}
}
if (Green2 == "")
 Green2 = ""$int(GreenDummy)$""; //record the final result
//------------------------------
//convert results to hexadecimal
//------------------------------
//part 1
if (Green1 == "10") Green1 = "A";
if (Green1 == "11") Green1 = "B";
if (Green1 == "12") Green1 = "C";
if (Green1 == "13") Green1 = "D";
if (Green1 == "14") Green1 = "E";
if (Green1 == "15") Green1 = "F";
//part 2
if (Green2 == "10") Green2 = "A";
if (Green2 == "11") Green2 = "B";
if (Green2 == "12") Green2 = "C";
if (Green2 == "13") Green2 = "D";
if (Green2 == "14") Green2 = "E";
if (Green2 == "15") Green2 = "F";
//combine results...
GreenFinal = ""$Green1$""$Green2$"";

//----------------------------
//BLUE
//----------------------------
 BigBlue = -1;
 BlueDummy = MamaBytes.G; // get the Blue byte
 BlueDummy = BlueDummy / 15;

 //SUPER MASSIVE IF SCENARIO FUN TIME!
 if (BlueDummy == 17) { Blue1 = "F"; Blue2 = "F"; BigBlue = -2; } //h4x
 if ((BlueDummy >= 16) && (BlueDummy < 17) && (BigBlue == -1)) { BlueDummy -= 16; BigBlue = 16; }
 if ((BlueDummy >= 15) && (BlueDummy < 16) && (BigBlue == -1)) { BlueDummy -= 15; BigBlue = 15; } 
 if ((BlueDummy >= 14) && (BlueDummy < 15) && (BigBlue == -1)) { BlueDummy -= 14; BigBlue = 14; } 
 if ((BlueDummy >= 13) && (BlueDummy < 14) && (BigBlue == -1)) { BlueDummy -= 13; BigBlue = 13; } 
 if ((BlueDummy >= 12) && (BlueDummy < 13) && (BigBlue == -1)) { BlueDummy -= 12; BigBlue = 12; } 
 if ((BlueDummy >= 11) && (BlueDummy < 12) && (BigBlue == -1)) { BlueDummy -= 11; BigBlue = 11; } 
 if ((BlueDummy >= 10) && (BlueDummy < 11) && (BigBlue == -1)) { BlueDummy -= 10; BigBlue = 10; } 
 if ((BlueDummy >= 9) && (BlueDummy < 10) && (BigBlue == -1)) { BlueDummy -= 9; BigBlue = 9; } 
 if ((BlueDummy >= 8) && (BlueDummy < 9) && (BigBlue == -1)) { BlueDummy -= 8; BigBlue = 8; } 
 if ((BlueDummy >= 7) && (BlueDummy < 8) && (BigBlue == -1)) { BlueDummy -= 7; BigBlue = 7; } 
 if ((BlueDummy >= 6) && (BlueDummy < 7) && (BigBlue == -1)) { BlueDummy -= 6; BigBlue = 6; } 
 if ((BlueDummy >= 5) && (BlueDummy < 6) && (BigBlue == -1)) { BlueDummy -= 5; BigBlue = 5; } 
 if ((BlueDummy >= 4) && (BlueDummy < 5) && (BigBlue == -1)) { BlueDummy -= 4; BigBlue = 4; } 
 if ((BlueDummy >= 3) && (BlueDummy < 4) && (BigBlue == -1)) { BlueDummy -= 3; BigBlue = 3; } 
 if ((BlueDummy >= 2) && (BlueDummy < 3) && (BigBlue == -1)) { BlueDummy -= 2; BigBlue = 2; }  
 if ((BlueDummy >= 1) && (BlueDummy < 2) && (BigBlue == -1)) { BlueDummy -= 1; BigBlue = 1; } 
 if ((BlueDummy >= 0) && (BlueDummy < 1) && (BigBlue == -1)) { BigBlue = 0; Blue1 = "0"; }
 BlueDummy = BlueDummy * 15; //find out how many we have in the ones space

if ((BigBlue <= 16) && (BigBlue > 0)) //if we're not over 16
{
 BigBlue -= 1; //adjust the biggy for recording
 Blue1 = ""$BigBlue$""; //record the biggy
 BlueAdd = 15 - BigBlue; //find the difference between the biggy and 15
 BlueDummy += BlueAdd; //then add the difference to the ones space
if (BlueDummy > 15) //if we've broken the normal limit
{
 BlueDummy -= 15; //settle the difference
 BigBlue += 1; //and fix the biggy
 Blue1 = ""$BigBlue$""; //then RE-record the biggy because of FUBAR-ness
}
}
if (Blue2 == "")
 Blue2 = ""$int(BlueDummy)$""; //record the final result
//------------------------------
//convert results to hexadecimal
//------------------------------
//part 1
if (Blue1 == "10") Blue1 = "A";
if (Blue1 == "11") Blue1 = "B";
if (Blue1 == "12") Blue1 = "C";
if (Blue1 == "13") Blue1 = "D";
if (Blue1 == "14") Blue1 = "E";
if (Blue1 == "15") Blue1 = "F";
//part 2
if (Blue2 == "10") Blue2 = "A";
if (Blue2 == "11") Blue2 = "B";
if (Blue2 == "12") Blue2 = "C";
if (Blue2 == "13") Blue2 = "D";
if (Blue2 == "14") Blue2 = "E";
if (Blue2 == "15") Blue2 = "F";
//combine results...
BlueFinal = ""$Blue1$""$Blue2$"";

//---------------------------------
//COMBINE EVERYTHING TO 1 HEX VALUE
//---------------------------------
FinalHex = ""$RedFinal$""$GreenFinal$""$BlueFinal$"";

return FinalHex; //glad that's over with!
}

//===========================
//RGB Byte Computing
//===========================
function color GetBulkColor()
{
 local color ColorResult;

 ColorResult.A = 0;

 if (NumBars == 32) //light green
 {
  ColorResult.B = 0;
  ColorResult.G = 255;
  ColorResult.R = 0;
 }

 if (NumBars == 1) //pure red
 {
  ColorResult.R = 255;
  ColorResult.G = 0;
  ColorResult.B = 0;
 }

 if (NumBars == 0) //gray
 {
  ColorResult.R = 128;
  ColorResult.G = 128;
  ColorResult.B = 128;
 }

 if ((NumBars >= 22) && (NumBars < 32)) //light green to green
 {
  ColorResult.B = 192 - (((32 - NumBars) * 19.2) - 1);
  ColorResult.G = 255;
  ColorResult.R = 0;
 }
 if ((NumBars >= 11) && (NumBars < 22)) //green to yellow
 {
  ColorResult.R = ((255 / NumBars) * 11);
  ColorResult.G = 255;
  ColorResult.B = 0;
 }
 if ((NumBars >= 2) && (NumBars < 11)) //yellow to red
 {
  ColorResult.G = 255 - (((11 - NumBars) * 25.6) - 1);
  ColorResult.R = 255;
  ColorResult.B = 0;
 }

 return ColorResult;
}

function UpdateBulkDescription() //Update the description crap...
{
 local Color NumColor; //the color for the number
 local string bEmpty; //stuff to throw on if we're empty
 local string BarTense; //proper tense for choosing between Bars or Bar
 local string AppetizationState; //what state does this make our appetite feel?
 local string HexValue, HexString;

//-------------------------------------
//Bar tense setting
//-------------------------------------
 BarTense = "Bars"; //assume Bars...
if (NumBars == 1)
 BarTense = "Bar"; //unless we have only one.
//-------------------------------------
//appetization state setting
//-------------------------------------
 AppetizationState = "is some seriously damn good stuff"; //assume we're good stuff...
if (NumBars == 0)
 AppetizationState = "was SO good while it lasted"; //unless we're out.
//-------------------------------------
//bEmpty setting
//-------------------------------------
 bEmpty = "";      //leave it blank
if (NumBars == 0)  //unless we ARE empty
 bEmpty = "n empty";      //modify the article and add an adjective
//-------------------------------------
//proper color setting
//-------------------------------------
 NumColor = GetBulkColor();
 HexValue = ByteToHex(NumColor);
 HexString = "|c"$HexValue$"";
//-------------------------------------
//and finally put it all together...
//-------------------------------------
 Description = "A"$bEmpty$" 32 pack of White Chocolate Wafo Bars, boy this "$AppetizationState$". Winner of the King's Choice Award 2010. "$HexString$""$NumBars$" "$BarTense$" Inside";
}

function PostBeginPlay() //modified to load the proper description upon map change or summoning.
{
 Super.PostBeginPlay();

 UpdateBulkDescription();
}

state Activated
{
	function BeginState()
	{
	 local DeusExPlayer P;
	 local int RoomLeft, NumToGive, MaxToTake;	 
         local WhiteChocolateWafoBar2 SpawnedStack, Curwafo;
         local Inventory CurItem;
	 local Actor A;

       //hax to place items properly, copied from DeusExPlayer.uc
	 local int slotsCol, slotsRow, i, DefYSlot, DefXSlot;

	 P = DeusExPlayer(Owner);

         CurItem = P.Inventory;

	 //go through all the inventory items and see if we have any of the item we store
	 Curwafo = WhiteChocolateWafoBar2(P.FindInventoryType(class'WhiteChocolateWafoBar2'));

	 if ((Curwafo != None) && (Numbars < 32))
	 {
          MaxToTake = Curwafo.NumCopies;
          RoomLeft = 32 - Numbars;
          if (MaxToTake > RoomLeft) MaxToTake = RoomLeft;
	  Numbars += MaxToTake;
          Curwafo.NumCopies -= MaxToTake;
          if (Curwafo.bInObjectBelt)
           DeusExRootWindow(P.rootWindow).hud.belt.UpdateObjectText(Curwafo.beltPos);
	  if (Curwafo.NumCopies <= 0) Curwafo.Destroy();
          P.ClientMessage("|p1"$MaxToTake$" Inserted, You Now Have "$Numbars$" bars.");
	  P.PlaySound(sound'VendingSmokes', SLOT_Interact);
	 }
	 else if ((Curwafo == None) && (Numbars > 0))
	 {
          NumToGive = Numbars;
          if (NumToGive > 16) NumToGive = 16;
	  SpawnedStack = Spawn(class'MSBulk.WhiteChocolateWafoBar2',,,P.Location);
	  SpawnedStack.NumCopies = NumToGive;
	  Numbars -= NumToGive;
	  if (P.FindInventorySlot(SpawnedStack, True) == True)
	  {
		foreach SpawnedStack.BasedActors(class'Actor', A)
			A.SetBase(None);
	   SpawnedStack.Frob(P, P.InHand);
	   SpawnedStack.SetBase(P);

	     for( slotsRow=6; slotsRow > -1; slotsRow-- )
              for ( slotsCol=0; slotsCol < 5; slotsCol++ )
	       if (P.IsEmptyItemSlotXY(1,1,slotsCol,slotsRow) == True)
               {
		SpawnedStack.InvPosX = slotsCol;
		SpawnedStack.InvPosY = slotsRow;
                P.invSlots[(slotsRow * P.maxInvCols) + slotsCol] = 1;
		break;
	       }
	  }
          P.ClientMessage("|p1"$NumToGive$" bars Extracted, "$Numbars$" Remaining.");
	  P.PlaySound(sound'VendingSmokes', SLOT_Interact);
	 }
	 else if ((Curwafo == None) && (Numbars <= 0))
	 {
          P.ClientMessage("|p2This 32 pack is empty...");
	 }
	 else if ((Curwafo != None) && (Numbars == 32))
	 {
          P.ClientMessage("|p2This 32 pack is full...");
	 }
	 GotoState('DeActivated'); //Hack so it works like useonce() but DOESN'T destroy itself
	  //update descriptor crap and item count...
         SavedNumBars = NumBars;
         UpdateBulkDescription();
	}
Begin:
}

defaultproperties
{
     bCanHaveMultipleCopies=False
     bActivatable=True
     NumBars=32
     ItemName="|p1White Chocolate Wafo Bar 32 Pack"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.DXMPammobox'
     PickupViewMesh=LodMesh'DeusExItems.DXMPammobox'
     ThirdPersonMesh=LodMesh'DeusExItems.DXMPammobox'
     Icon=Texture'IconWafoBulkPack7'
     largeIcon=Texture'IconWafoBulkPack7'
     largeIconWidth=58
     largeIconHeight=48
     PickupViewScale=0.900000
     ThirdPersonScale=0.900000
     PlayerViewScale=0.900000
     DrawScale=0.900000
     Description="A 32 pack of White Chocolate Wafo Bars, boy this is some good stuff. Winner of the King's Choice Award 2010. |p2ERROR: Post begin play failed to activate bar count!"
     beltDescription="|p132-WAFO"
     Skin=Texture'WafoBulkPack7'
     Mesh=LodMesh'DeusExItems.DXMPammobox'
     CollisionRadius=22.500000
     CollisionHeight=14.400000
     Mass=12.000000
     Buoyancy=16.000000
     InvSlotsX=2
}
